% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_grep2.R
\name{grep2}
\alias{grep2}
\title{grep2}
\usage{
grep2(pattern, x, value = TRUE, invert = FALSE, perl = FALSE)
}
\arguments{
\item{pattern}{Character vector containing regular expression as cells to be matched in the given character vector.}

\item{x}{A character vector where matches are sought, or an object which can be coerced by as.character to a character vector. Long vectors are supported.}

\item{value}{Logical. If FALSE, a vector containing the (integer) indices of the matches determined by grep2 is returned, and if TRUE, a vector containing the matching elements themselves is returned.}

\item{invert}{Logical. If TRUE return indices or values for elements that do not match.}

\item{perl}{Logical. Should Perl-compatible regexps be used?}
}
\value{
grep2(value = FALSE) returns a vector of the indices of the elements of x that yielded a match (or not, for invert = TRUE). This will be an integer vector unless the input is a long vector, when it will be a double vector. \cr\cr grep2(value = TRUE) returns a character vector containing the selected elements of x (after coercion, preserving names but no other attributes).
}
\description{
Extension of grep(). Allows to identify and extract cells with/without multiple search patterns that are connected with AND.
}
\examples{
x<-c("ab","ac","ad","bc","bad")
grep2(c("a","b"),x)
grep2(c("a","b"),x,invert=TRUE)
grep2(c("a","b"),x,value=FALSE)
}
\seealso{
\code{\link[base]{grep}}
}
