% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAEQJMMLSM.R
\name{MAEQJMMLSM}
\alias{MAEQJMMLSM}
\title{A metric of prediction accuracy of joint model by comparing the predicted risk
with the empirical risks stratified on different predicted risk group.}
\usage{
MAEQJMMLSM(
  seed = 100,
  object,
  landmark.time = NULL,
  horizon.time = NULL,
  obs.time = NULL,
  method = c("Laplace", "GH"),
  quadpoint = NULL,
  maxiter = 1000,
  survinitial = TRUE,
  n.cv = 3,
  quantile.width = 0.25,
  opt = "nlminb",
  initial.para = FALSE,
  ...
)
}
\arguments{
\item{seed}{a numeric value of seed to be specified for cross validation.}

\item{object}{object of class 'JMMLSM'.}

\item{landmark.time}{a numeric value of time for which dynamic prediction starts..}

\item{horizon.time}{a numeric vector of future times for which predicted probabilities are to be computed.}

\item{obs.time}{a character string of specifying a longitudinal time variable.}

\item{method}{estimation method for predicted probabilities. If \code{Laplace}, then the empirical empirical
estimates of random effects is used. If \code{GH}, then the standard Gauss-Hermite quadrature is used.}

\item{quadpoint}{the number of standard Gauss-Hermite quadrature points if \code{method = "GH"}.}

\item{maxiter}{the maximum number of iterations of the EM algorithm that the 
function will perform. Default is 10000.}

\item{survinitial}{Fit a Cox model to obtain initial values of the parameter estimates. Default is TRUE.}

\item{n.cv}{number of folds for cross validation. Default is 3.}

\item{quantile.width}{a numeric value of width of quantile to be specified. Default is 0.25.}

\item{opt}{Optimization method to fit a linear mixed effects model, either nlminb (default) or optim.}

\item{initial.para}{Initial guess of parameters for cross validation. Default is FALSE.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
a list of matrices with conditional probabilities for subjects.
}
\description{
A metric of prediction accuracy of joint model by comparing the predicted risk
with the empirical risks stratified on different predicted risk group.
}
\seealso{
\code{\link{JMMLSM}, \link{survfitJMMLSM}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
