% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_cpi.R
\name{get_japan_cpi}
\alias{get_japan_cpi}
\title{Get Japan's Consumer Price Index from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/FP.CPI.TOTL}
}
\usage{
get_japan_cpi()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Consumer price index (2010 = 100)")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Consumer Price Index value in numeric form
}
}
\description{
Retrieves Japan's Consumer Price Index (2010 = 100)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{FP.CPI.TOTL}.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_japan_cpi()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
