% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JointAI.R
\name{ns}
\alias{ns}
\title{Generate a Basis Matrix for Natural Cubic Splines}
\usage{
ns(x, df = NULL, knots = NULL, intercept = FALSE,
  Boundary.knots = range(x))
}
\arguments{
\item{x}{the predictor variable.  Missing values are allowed.}

\item{df}{degrees of freedom.  One can supply \code{df} rather than
    knots; \code{ns()} then chooses \code{df - 1 - intercept} knots at
    suitably chosen quantiles of \code{x} (which will ignore missing
    values).  The default, \code{df = NULL}, sets the number of
    inner knots as \code{length(knots)}.}

\item{knots}{breakpoints that define the spline.  The default is no
    knots; together with the natural boundary conditions this results in
    a basis for linear regression on \code{x}.  Typical values are the
    mean or median for one knot, quantiles for more knots.  See also
    \code{Boundary.knots}.}

\item{intercept}{if \code{TRUE}, an intercept is included in the
    basis; default is \code{FALSE}.}

\item{Boundary.knots}{boundary points at which to impose the natural
    boundary conditions and anchor the B-spline basis (default the range
    of the data).  If both \code{knots} and \code{Boundary.knots} are
    supplied, the basis parameters do not depend on \code{x}. Data can
    extend beyond \code{Boundary.knots}}
}
\description{
This function just calls \code{ns()} from the
\href{https://CRAN.R-project.org/package=splines}{\strong{splines}}
package.
}
\keyword{internal}
