% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kerGauss.R
\name{kerGauss}
\alias{kerGauss}
\title{Gaussian kernel computation}
\usage{
kerGauss(gamma, z1, z2)
}
\arguments{
\item{gamma}{A number, the bandwidth parameter in the Gaussian kernel.}

\item{z1}{A vector, the first input of the Gaussian kernel.}

\item{z2}{A vector, the second input of the Gaussian kernel.}
}
\value{
A number, the value of the Gaussian kernel function.
}
\description{
Computing the values of Gaussian kernel functions.
}
\details{
The Gaussian kernel is defined as k(z1,z2)=exp(-gamma*||z1-z2||^2).
}
\examples{
gamma=0.02
z1=c(3,1,3)
z2=c(8,1,9)
kerGauss(gamma,z1,z2)

}
