% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanEst.R
\name{MeanEst}
\alias{MeanEst}
\title{Local linear estimates of mean function}
\usage{
MeanEst(Lt, Ly, kern, bw, gridout)
}
\arguments{
\item{Lt}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation time in ascending order for each subject.}

\item{Ly}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the measurements of each subject at the observation time correspond to \code{Lt}.}

\item{kern}{A \code{character} denoting the kernel type; 'epan'(Epanechnikov), 'unif'(Uniform), 'quar'(Quartic), 'gauss'(Gaussian).}

\item{bw}{A scalar denoting the bandwidth.}

\item{gridout}{A \code{vector} denoting the time points that the mean function need to be estimated.}
}
\value{
A \code{list} containing the following components:
\item{Grid}{A \code{vector} denoting the time points that the mean function need to be estimated.}
\item{mean}{A \code{vector} containing the mean function estimates.}
}
\description{
Local linear estimates of mean function.
}
\examples{
# Generate data
n <- 100
interval <- c(0, 10)
lambda_1 <- 9 #the first eigenvalue
lambda_2 <- 1.5 #the second eigenvalue
eigfun <- list()
eigfun[[1]] <- function(x){cos(pi * x/10)/sqrt(5)}
eigfun[[2]] <- function(x){sin(pi * x/10)/sqrt(5)}
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
DataNew <- GenDataKL(n, interval = interval, sparse = 6:8, regular = FALSE,
                     meanfun = function(x){x}, score = score,
                     eigfun = eigfun, sd = sqrt(0.1))
# Mean function estimate at all observation time points
bwOpt <- GetGCVbw1D(DataNew$Lt, DataNew$Ly, kern = "epan")
meanest <- MeanEst(DataNew$Lt, DataNew$Ly, kern = "epan", bw = bwOpt,
                   gridout = sort(unique(unlist(DataNew$Lt))))
plot(meanest$Grid, meanest$mean)
}
