% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkedLR.R
\name{linkedLR}
\alias{linkedLR}
\title{LR with pairwise linked markers}
\usage{
linkedLR(
  pedigrees,
  linkageMap = map50,
  linkedPairs = NULL,
  maxdist = Inf,
  markerData = NULL,
  mapfun = "Kosambi",
  lumpSpecial = TRUE,
  alleleLimit = 10,
  verbose = TRUE,
  debug = FALSE
)
}
\arguments{
\item{pedigrees}{A list of two pedigrees.}

\item{linkageMap}{A data frame with columns including \code{Marker}, \code{Chr} and
\code{cM}. By default, a built-in map \code{norSTR::map50} of 50 STR markers is used.}

\item{linkedPairs}{A list of marker pairs. If not supplied, calculated as
\code{getLinkedPairs(markerData$Marker, linkageMap, maxdist = maxdist)}.}

\item{maxdist}{A number, passed onto \code{getLinkedMarkers()} if \code{linkedPairs} is
NULL.}

\item{markerData}{A data frame with marker data, typically the output of
\code{markerSummary(pedigrees)}.}

\item{mapfun}{Name of the map function to be used; either "Haldane" or
"Kosambi" (default).}

\item{lumpSpecial}{A logical indicating if special lumping should be
activated. This is strongly recommended in all cases with linked STR
markers.}

\item{alleleLimit}{A number, by default 10, passed on to
\code{\link[pedprobr:likelihood]{pedprobr::likelihood2()}}.}

\item{verbose}{A logical, by default TRUE.}

\item{debug}{A logical, by default FALSE.}
}
\value{
A data frame with detailed LR results.
}
\description{
This function does the main LR calculations of the KLINK app.
}
\examples{
linkedLR(paternity)

# Detailed messages, including reports on lumping
linkedLR(paternity, debug = TRUE)

# For testing
# .linkedLR(paternity, markerpair = c("SE33", "D6S474"))

}
