% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSEA.Scores.R
\name{KSEA.Scores}
\alias{KSEA.Scores}
\title{The KSEA App Analysis (KSEA Kinase Scores Only)}
\usage{
KSEA.Scores(KSData, PX, NetworKIN, NetworKIN.cutoff)
}
\arguments{
\item{KSData}{the Kinase-Substrate dataset uploaded from the file 
prefaced with "PSP&NetworKIN_"
available from github.com/casecpb/KSEA/}

\item{PX}{the experimental data file formatted as described in the KSEA.Complete() documentation}

\item{NetworKIN}{a binary input of TRUE or FALSE, indicating whether or not to include NetworKIN predictions; 
NetworKIN = TRUE means inclusion of NetworKIN predictions}

\item{NetworKIN.cutoff}{a numeric value between 1 and infinity setting 
the minimum NetworKIN score (can be left out if NetworKIN = FALSE)}
}
\value{
creates a new data frame in R with all the KSEA kinase scores, 
        along with each one's statistical assessment
}
\description{
Takes a formatted phoshoproteomics data input and returns just the KSEA kinase scores and statistics
}
\examples{
scores = KSEA.Scores(KSData, PX, NetworKIN=TRUE, NetworKIN.cutoff=3)
scores = KSEA.Scores(KSData, PX, NetworKIN=FALSE)

}
\references{
Casado et al. (2013) Sci Signal. 6(268):rs6

Hornbeck et al. (2015) Nucleic Acids Res. 43:D512-20

Horn et al. (2014) Nature Methods 11(6):603-4
}
