% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_r.R
\name{test_r}
\alias{test_r}
\title{Test the significance, analyze the power, and plan the sample size for r.}
\usage{
test_r(r = NULL, n = NULL, sig_level = 0.05, power = 0.8)
}
\arguments{
\item{r}{Pearson's correlation. Cohen(1988) suggested >=0.1, >=0.3, and >=0.5 as cut-off values
of Pearson's correlation r for small, medium, and large effect sizes, respectively.}

\item{n}{Sample size of r. Non-integer \code{n} would be converted to be a integer using \code{as.integer()}.
\code{n} should be at least 3.}

\item{sig_level}{Expected significance level.}

\item{power}{Expected statistical power.}
}
\value{
A list with the following results:
\verb{[[1]]} \code{r}, the given r;
\verb{[[2]]} \code{d}, Cohen's d derived from \code{r}; Cohen (1988) suggested >=0.2, >=0.5, and >=0.8
as cut-off values of \code{d} for small, medium, and large effect sizes, respectively.
\verb{[[3]]} Integer \code{n};
\verb{[[4]]} t-test of \code{r} (incl., \code{r}, \code{df} of r, \code{SE_r}, \code{t}, \code{p_r}),
95\% CI of \code{r} based on t -test (\code{LLCI_r_t}, \code{ULCI_r_t}),
and post-hoc power of \code{r} (incl., \code{delta_post}, \code{power_post});
\verb{[[5]]} Fisher's z transformation (incl., \code{fz} of \code{r}, z-test of \code{fz} [\code{SE_fz}, \code{z}, \code{p_fz}],
and 95\% CI of \code{r} derived from \code{fz}.

Note that the returned CI of \code{r} may be out of r's valid range [-1, 1].
This "error" is deliberately left to users, who should correct the CI manually in reports.
}
\description{
Test the significance, analyze the power, and plan the sample size for r.
}
\details{
To test the significance of the r using the one-sample t-test,
the SE of \code{r} is determined by the following formula: \code{SE = sqrt((1 - r^2)/(n - 2))}.
Another way is transforming \code{r} to Fisher's z using the following formula:
\code{fz = atanh(r)} with the SE of \code{fz} being \code{sqrt(n - 3)}.
Fisher's z is commonly used to compare two Pearson's correlations from independent samples.
Fisher's transformation is presented here only to satisfy the curiosity of users who are
interested in the difference between t-test and Fisher's transformation.

The post-hoc power of \code{r}'s t-test is computed through the way of Aberson (2019).
Other software and R packages like SPSS and \code{pwr} give different power estimates due to
underlying different formulas. \code{Keng} adopts Aberson's approach because this approach guarantees
the equivalence of r and PRE.
}
\examples{
test_r(0.2, 193)

# compare the p-values of t-test and Fisher's transformation
for (i in seq(30, 200, 10)) {
cat(c("n = ", i, ", difference between ps = ",
       format(
        abs(test_r(0.2, i)[["t_test"]]["p_r"] - test_r(0.2, i)[["Fisher_z"]]["p_fz"]),
        nsmall = 12,
        scientific = FALSE)),
      sep = "",
      fill = TRUE)
}
}
\references{
Aberson, C. L. (2019). \emph{Applied power analysis for the behavioral sciences}. Routledge.

Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Routledge.
}
