% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimu.R
\name{SimuWaveInv}
\alias{SimuWaveInv}
\title{Simulate Wave Data}
\usage{
SimuWaveInv(n, sigma, seed = NA, tau, h, a0 = 0)
}
\arguments{
\item{n}{Number of data points}

\item{sigma}{Standard deviation of the noise added to the signal}

\item{seed}{An optional seed for random number generation to make results reproducible}

\item{tau}{The locations of change points in the underlying trend}

\item{h}{The slope of the \eqn{length(tau)+1} segments of the underlying trend}

\item{a0}{The initial point value}
}
\value{
A list containing the piecewise linear simulated data and the underlying trend:
\item{x}{The set \{ \eqn{\frac{1}{n}}, \eqn{\frac{2}{n}}, \eqn{\frac{3}{n}},\dots, \eqn{1} \}}
\item{y}{The piecewise linear simulated data of length \eqn{n}}
\item{y0}{The underlying trend of length \eqn{n}}
\item{setA}{The set of position indicators of change points in the simulated data}
\item{tau}{The locations of change points in the underlying trend}
}
\description{
This function generates data points of piecewise linear trends.
}
\examples{
tau = c(0.1, 0.3, 0.4, 0.7, 0.85)
h = c(-1, 5, 3, 0, -1, 2)
a0 = -10
WaveData <- SimuWaveInv(n = 650, sigma = 0.1, seed = 50, tau = tau, h = h, a0 = a0)
plot(WaveData$x, WaveData$y, xlab="", ylab="")
lines(WaveData$x, WaveData$y0, col = "red")
print(WaveData$setA)
print(WaveData$tau)
}
\seealso{
\code{\link{SimuBlocksInv}}
}
