% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2e_regression_MM.R
\name{l2e_regression_MM}
\alias{l2e_regression_MM}
\title{L2E multivariate regression - MM}
\usage{
l2e_regression_MM(
  y,
  X,
  beta,
  tau,
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{response}

\item{X}{Design matrix}

\item{beta}{initial vector of regression coefficients}

\item{tau}{initial precision estimate}

\item{max_iter}{maximum number of iterations}

\item{tol}{relative tolerance}

\item{Show.Time}{Report the computing time}
}
\value{
Returns a list object containing the estimates for beta (vector) and tau (scalar),
the number of outer block descent iterations until convergence (scalar),
and the number of inner iterations per outer iteration for updating beta and eta (vectors)
}
\description{
\code{l2e_regression_MM} performs L2E multivariate regression via block coordinate descent
with MM for updating beta and modified Newton for updating tau.
}
\examples{
# Bank data example
y <- bank$y
X <- as.matrix(bank[,1:13])
X0 <- as.matrix(cbind(rep(1,length(y)), X))
tau <- 1/mad(y)
b <- matrix(0, 14, 1)

sol <- l2e_regression_MM(y, X0, b, tau)
r <- y - X0 \%*\% sol$beta
ix <- which(abs(r) > 3/sol$tau)
l2e_fit <- X0 \%*\% sol$beta

plot(y, l2e_fit, ylab='Predicted values', pch=16, cex=0.8)
points(y[ix], l2e_fit[ix], pch=16, col='blue', cex=0.8)

}
