% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_beta_sparse_ncv.R
\name{update_beta_sparse_ncv}
\alias{update_beta_sparse_ncv}
\title{Beta update in L2E sparse regression - NCV}
\usage{
update_beta_sparse_ncv(
  y,
  X,
  beta,
  tau,
  lambda,
  penalty,
  max_iter = 100,
  tol = 1e-04
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix}

\item{beta}{Initial vector of regression coefficients}

\item{tau}{Initial precision estimate}

\item{lambda}{Tuning parameter}

\item{penalty}{Available penalties include lasso, MCP and SCAD.}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}
}
\value{
Returns a list object containing the new estimate for beta (vector) and the number of iterations (scalar) the update step utilized
}
\description{
\code{update_beta_sparse_ncv} updates beta for L2E sparse regression using existing penalization methods
}
