% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{est_hdchange}
\alias{est_hdchange}
\title{Construct an S3 class 'no_nbd' or 'nbd' for change-point estimation}
\usage{
est_hdchange(hdobj, test_stats, threshold, stat_all, critical_values)
}
\arguments{
\item{hdobj}{An S3 object of class 'no_nbd' or 'nbd' generated by \code{\link[=ts_hdchange]{ts_hdchange()}}.}

\item{test_stats}{A list containing the test statistics generated by \code{\link[=get_teststats]{get_teststats()}}.}

\item{threshold}{The threshold in break estimation.}

\item{stat_all}{An array of test statistics generated by \code{\link[=get_V_l2_MAinf]{get_V_l2_MAinf()}}.}

\item{critical_values}{An array of quantiles for critical values.}
}
\value{
An S3 object of class 'no_nbd' or 'nbd' used as the argument of \code{\link[=get_breaks]{get_breaks()}}.
}
\description{
Construct an S3 class 'no_nbd' or 'nbd' for change-point estimation
}
\examples{
# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

teststats <- get_teststats(ts_no_nbd)
V_12_MAinf <- get_V_l2_MAinf(ts_no_nbd)

estobj <- est_hdchange(hdobj = ts_no_nbd, test_stats = teststats$stat_max,
threshold = 1e-5, stat_all = V_12_MAinf, critical_values = c(0.01, 0.05, 0.1))


}
