% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{get_critical}
\alias{get_critical}
\title{Obtain critical values and threshold}
\usage{
get_critical(hdobj)
}
\arguments{
\item{hdobj}{An S3 object of class 'no_nbd' or 'nbd' generated
by \code{\link[=ts_hdchange]{ts_hdchange()}}.}
}
\value{
A list containing the critical values and
the threshold parameter \eqn{\omega}.
}
\description{
Obtain critical values and threshold
}
\examples{
# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

crit <- get_critical(ts_no_nbd)

}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
