% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAR.R
\name{LAR}
\alias{LAR}
\title{Estimate Lifetime Attributable Risk for one person}
\usage{
LAR(
  data,
  basedata,
  sim = 300,
  seed = 99,
  current = as.numeric(substr(Sys.Date(), 1, 4)),
  ci = 0.9,
  weight = NULL,
  DDREF = TRUE,
  basepy = 1e+05
)
}
\arguments{
\item{data}{data frame containing demographic information and exposure information. See 'Details'.}

\item{basedata}{a list of the data of lifetime table and incidence rate table.
The first element is lifetime table and the second is incidence rate table.}

\item{sim}{number of iteration of simulation.}

\item{seed}{a random seed number.}

\item{current}{a current year. default is year of the system time.}

\item{ci}{confidence level of the confidence interval.}

\item{weight}{a list containing the value between 0 and 1 which is a weight on ERR model. See 'Details'.}

\item{DDREF}{logical. Whether to apply the dose and dose-rate effectiveness factor.}

\item{basepy}{number of base person-years}
}
\value{
\code{LAR} returns an object of "\code{LAR}" class.

An object of class "\code{LAR}" is a list containing the following components:
\describe{
\item{\code{LAR}}{Lifetime attributable risk (LAR) from the time of exposure to the end of the expected lifetime.}
\item{\code{F_LAR}}{Future attributable risk from current to the expected lifetime.}
\item{\code{LBR}}{Lifetime baseline risk.}
\item{\code{BFR}}{Baseline future risk.}
\item{\code{LFR}}{Lifetime fractional risk.}
\item{\code{TFR}}{Total future risk.}
\item{\code{current}}{Current year.}
\item{\code{ci}}{Confidence level.}
\item{\code{pinfo}}{Information of the person.}
}
}
\description{
\code{LAR} is used to estimate lifetime attributable radiation-related cancer risk for data with one person.
}
\details{
The maximum age in \code{LAR} is set as 100. If the data contains
 \code{birth} which makes attained age (=\code{current} - \code{birth})
 exceed 100, the result has no useful value.

\code{data} should include information which includes gender, year of birth,
year of exposure, sites where exposed, exposure rate, distribution of dose and
dose parameters of exosed radiation. The name of each variables must be
\code{sex}, \code{birth}, \code{exposure}, \code{site}, \code{exposure_rate},
\code{dosedist}, \code{dose1}, \code{dose2}, \code{dose3}.

For some variables, there is a fixed format. \code{sex} can have the component 'male' or 'female'.
\code{site} can have the component 'stomach', 'colon', 'liver', 'lung', 'breast', 'ovary', 'uterus', 'prostate', 'bladder', 'brain/cns',
'thyroid', 'remainder', 'oral', 'oesophagus', 'rectum', 'gallbladder', 'pancreas', 'kidney', 'leukemia'.
\code{exposure_rate} can have the component 'acute' or 'chronic'.
\code{dosedist} can have the component 'fixedvalue', 'lognormal', 'normal', 'triangular', 'logtriangular', 'uniform', 'loguniform'.

\code{dose1}, \code{dose2}, \code{dose3} are parameters of dose distribution. The parameters for each distribution are that:
\describe{
\item{fixedvalue}{dose value (dose1)}
\item{lognormal}{median (dose1), geometric standard deviation (dose2)}
\item{normal}{mean (dose1), standard deviation (dose2)}
\item{triangular or logtriangular}{minimum (dose1), mode (dose2), maximum (dose3)}
\item{uniform or loguniform}{minimum (dose1), maximum (dose2)}
}

\code{weight}
}
\examples{
## example with lifetime and incidence rate table in 2010 Korea.
organ2 <- split(organ, organ$ID)[[1]]   ## data of one person.

## defualt
lar1 <- LAR(organ2, basedata = list(life2010, incid2010))
summary(lar1)

## change the weight for ERR and EAR models
weight_list <- list("rectum" = 0.5)
lar2 <- LAR(organ2, basedata = list(life2010, incid2010), weight = weight_list)
summary(lar2)

## change the DDREF option (DDREF=FALSE)
lar3 <- LAR(organ2, basedata = list(life2010, incid2010), DDREF = FALSE)
summary(lar3)


}
\references{
Berrington de Gonzalez, A., Iulian Apostoaei, A., Veiga, L.,
 Rajaraman, P., Thomas, B., Owen Hoffman, F., Gilbert, E. and Land, C.
 (2012). RadRAT: a radiation risk assessment tool for lifetime cancer risk
 projection. \emph{Journal of Radiological Protection}, \bold{32(3)},
 pp.205-222.

National Research Council (NRC) and Committee to Assess Health
 Risks from Exposure to Low Levels of Ionizing Radiation (2005) \emph{Health
 Risks from Exposure to Low Levels of Ionizing Radiation: BEIR VII Phase 2}
 (Washington, DC: National Academy of Sciences)
}
\seealso{
\code{\link{LAR_batch}}, \code{\link{LAR_group}}
}
