% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAR_batch.R
\name{LAR_batch}
\alias{LAR_batch}
\title{Estimate Lifetime Attributable Risk for several people}
\usage{
LAR_batch(
  data,
  pid,
  basedata,
  sim = 300,
  seed = 99,
  current = as.numeric(substr(Sys.Date(), 1, 4)),
  ci = 0.9,
  weight = NULL,
  DDREF = TRUE,
  basepy = 1e+05
)
}
\arguments{
\item{data}{data frame containing demographic information and exposure information. See 'Details'.}

\item{pid}{a vector which distinguish each person.}

\item{basedata}{a list of the data of lifetime table and incidence rate table.
The first element is lifetime table and the second is incidence rate table.}

\item{sim}{number of iteration of simulation.}

\item{seed}{a random seed number.}

\item{current}{a current year. default is year of the system time.}

\item{ci}{confidence level of the confidence interval.}

\item{weight}{a list containing the value between 0 and 1 which is a weight on ERR model. See 'Details'.}

\item{DDREF}{logical. Whether to apply the dose and dose-rate effectiveness factor.}

\item{basepy}{number of base person-years}
}
\value{
\code{LAR_batch} returns an object of multiple classes
 "\code{LAR_batch}", "\code{LAR}". An object of class \code{LAR_batch} is a
 list of \code{LAR} class objects which names of elements are \code{ID} of each
 person.
}
\description{
\code{LAR_batch} is used to estimate lifetime attributable radiation-related cancer risk for data with several people.
}
\examples{
## example with lifetime and incidence rate table in 2010 Korea.
lar1 <- LAR_batch(nuclear, pid=nuclear$ID, basedata = list(life2010, incid2010))
summary(lar1)

}
\references{
Berrington de Gonzalez, A., Iulian Apostoaei, A., Veiga, L., Rajaraman, P., Thomas, B., Owen Hoffman, F., Gilbert, E. and Land, C. (2012). RadRAT: a radiation risk assessment tool for lifetime cancer risk projection. \emph{Journal of Radiological Protection}, \bold{32(3)}, pp.205-222.

National Research Council (NRC) and Committee to Assess Health Risks from Exposure to Low Levels of Ionizing Radiation (2005) \emph{Health Risks from Exposure to Low Levels of Ionizing Radiation: BEIR VII Phase 2} (Washington, DC: National Academy of Sciences)
}
\seealso{
\code{\link{LAR}}, \code{\link{LAR_group}}
}
