% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed_search.R
\name{pubmed_search}
\alias{pubmed_search}
\title{Search PubMed for articles with optimized performance}
\usage{
pubmed_search(
  query,
  max_results = 1000,
  use_mesh = FALSE,
  date_range = NULL,
  api_key = NULL,
  batch_size = 200,
  verbose = TRUE,
  use_cache = TRUE,
  retry_count = 3,
  retry_delay = 1
)
}
\arguments{
\item{query}{Character string containing the search query.}

\item{max_results}{Maximum number of results to return.}

\item{use_mesh}{Logical. If TRUE, will attempt to map query terms to MeSH terms.}

\item{date_range}{Character vector of length 2 with start and end dates in format "YYYY/MM/DD".}

\item{api_key}{Character string. NCBI API key for higher rate limits (optional).}

\item{batch_size}{Integer. Number of records to fetch in each batch (default: 200).}

\item{verbose}{Logical. If TRUE, prints progress information.}

\item{use_cache}{Logical. If TRUE, cache results to avoid redundant API calls.}

\item{retry_count}{Integer. Number of times to retry failed API calls.}

\item{retry_delay}{Integer. Initial delay between retries in seconds.}
}
\value{
A data frame containing the search results with PubMed IDs, titles, and other metadata.
}
\description{
This function searches PubMed using the NCBI E-utilities API via the rentrez package.
The implementation includes optimizations for speed, memory efficiency, and reliability.
}
