% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{safe_diversify}
\alias{safe_diversify}
\title{Diversify ABC results with error handling}
\usage{
safe_diversify(
  top_results,
  diversity_method = "both",
  max_per_group = 5,
  min_score = 1e-04,
  min_results = 5,
  fallback_count = 15,
  verbose = TRUE
)
}
\arguments{
\item{top_results}{The top ABC results to diversify}

\item{diversity_method}{Method for diversification (default: "both")}

\item{max_per_group}{Maximum results per group (default: 5)}

\item{min_score}{Minimum score threshold (default: 0.0001)}

\item{min_results}{Minimum number of desired results (default: 5)}

\item{fallback_count}{Number of top results to use if diversification fails (default: 15)}

\item{verbose}{Logical; if TRUE, print status messages (default: TRUE)}
}
\value{
A data frame of diversified results
}
\description{
This function diversifies ABC results to avoid redundancy, with error handling
to ensure results are always returned.
}
