% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC1.R
\name{PPC1}
\alias{PPC1}
\title{Apply the PPC method to the Laplace factor model}
\usage{
PPC1(data, m)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{The number of principal components.}
}
\value{
Apro,Dpro,Sigmahatpro
}
\description{
This function computes Perturbation Principal Component Analysis (PPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and loss metrics for the estimated values compared to true values.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- PPC1(data, m)
print(results)
}
