% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOPC.R
\name{SOPC}
\alias{SOPC}
\title{Apply the SOPC method to the Laplace factor model}
\usage{
SOPC(data, m, gamma,eta)
}
\arguments{
\item{data}{A numeric matrix containing the data used in the SOPC analysis.}

\item{m}{is the number of principal component}

\item{gamma}{is a sparse parameter}

\item{eta}{is the proportion of online data to total data}
}
\value{
Aso,Dso
}
\description{
This function calculates various metrics for the sprase online principle component (SOPC) analysis
on the Laplace factor model.
}
\examples{
library(MASS)
library(matrixcalc)
library(LaplacesDemon)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- SOPC(data, m, gamma=0.03, eta=0.1)
print(results)
}
