% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICCLdown_Chart.R
\name{plot_GICCLdown_Chart}
\alias{plot_GICCLdown_Chart}
\title{Downward CUSUM Control Chart with Cautious Learning and Guaranteed Performance}
\usage{
plot_GICCLdown_Chart(
  alpha,
  beta,
  beta_ratio,
  H_delta,
  H_minus,
  known_alpha,
  k_l,
  delay,
  tau,
  n_I,
  n_II,
  faseI = NULL,
  faseII = NULL
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution (if \code{alpha_conocido = TRUE}).}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between \code{beta} and its estimation.}

\item{H_delta}{Increment of the lower control limit.}

\item{H_minus}{Initial lower control limit of the CUSUM chart.}

\item{known_alpha}{Indicates whether \code{alpha} is known (\code{TRUE}) or should be estimated (\code{FALSE}).}

\item{k_l}{Secondary control threshold used in the learning logic.}

\item{delay}{Number of observations before updating \code{beta0_est} and \code{H_minus_c}.}

\item{tau}{Time point at which the \code{beta} parameter changes.}

\item{n_I}{Sample size in Phase I (if \code{faseI} is not provided).}

\item{n_II}{Sample size in Phase II (if \code{faseII} is not provided).}

\item{faseI}{Data sample from Phase I (numeric vector). If \code{NULL}, it is generated internally.}

\item{faseII}{Data sample from Phase II (numeric vector). If \code{NULL}, it is generated internally.}
}
\value{
A plot showing the evolution of the downward CUSUM statistic with cautious learning, including:
\itemize{
\item The dynamically adjusted accumulated values of the CUSUM statistic.
\item Progressively updated control limits with guaranteed performance.
\item A summary of the parameters used in the control chart.
}
}
\description{
This function generates a downward CUSUM control chart for a Gamma distribution, incorporating a
cautious parameter updating mechanism based on guaranteed performance.

It enables dynamic process monitoring, ensuring progressive adaptation to changes in the distribution.

This approach follows the methodology presented in the work of Madrid-Alvarez, García-Díaz, and Tercero-Gómez (2024), where
a cautious learning scheme for parameter updating in CUSUM control charts applied to Gamma distributions is proposed.

The implementation captures changes in the distribution and adjusts the
control limits to enhance the detection of process variations.
\subsection{Features:}{
\itemize{
\item If the user does not provide Phase I and Phase II data, the function generates them automatically.
\item If \code{known_alpha = TRUE}, \code{alpha} is fixed and not estimated.
\item If \code{known_alpha = FALSE}, \code{alpha} is estimated from Phase I data.
\item Dynamic control limits and a summary of parameters are included.
\item Integrates a cautious learning scheme using the parameters \code{k_l}, \code{delay}, and \code{tau}.
}
}

\subsection{\strong{Recommendations}}{

The parameters \code{k_l}, \code{delay}, and \code{tau} are part of the cautious learning mechanism of the CUSUM chart. These values enable the dynamic
updating of \code{beta0_est} and \code{H_minus}, ensuring that the control chart progressively adapts to process changes, improving sensitivity in detecting deviations.

For proper implementation, it is recommended to reference the values proposed in:

\strong{Madrid-Alvarez, H. M., García-Díaz, J. C., & Tercero-Gómez, V. G. (2024).}
\emph{A CUSUM control chart for the Gamma distribution with cautious parameter learning.}
Quality Engineering, 1-23.

While these parameters have been tested and validated in the referenced article, users can adjust them based on the specific characteristics
of their process, considering factors such as system variability and desired update frequency.

Additionally, if detailed guidance on selecting values for \code{H_delta} and \code{H_minus} is needed, it is recommended to review the referenced article,
which presents calibration and adjustment strategies for these limits to ensure optimal control chart performance.
}
}
\examples{
# Option 1: Providing Phase I and Phase II data
phaseI_data <- rgamma(n = 200, shape = 1, scale = 1)
phaseII_data <- rgamma(n = 710, shape = 1, scale = 1)
plot_GICCLdown_Chart(alpha = 1, beta = 1, beta_ratio = 1/2, H_delta = 4.2433,
                     H_minus= -4.8257, known_alpha = FALSE, k_l = 0.739588,
                     delay = 25, tau = 1, n_I = 200, n_II = 700,
                     faseI = phaseI_data, faseII = phaseII_data)

# Option 2: Without providing data, the function automatically generates them
plot_GICCLdown_Chart(alpha = 1, beta = 1, beta_ratio = 1/2, H_delta = 1.6763,
                     H_minus = -4.8257, known_alpha = FALSE, k_l = 0.739588,
                     delay = 25, tau = 1, n_I = 200,
                     n_II = 710, faseI = NULL, faseII = NULL)



}
