% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm.cv.R
\name{llm.cv}
\alias{llm.cv}
\title{Runs v-fold cross validation with LLM}
\usage{
llm.cv(X, Y, cv, threshold_pruning = 0.25, nbr_obs_leaf = 100)
}
\arguments{
\item{X}{Dataframe containing numerical independent variables.}

\item{Y}{Numerical vector of dependent variable. Currently only binary classification is supported.}

\item{cv}{An integer specifying the number of folds in the cross-validation.}

\item{threshold_pruning}{Set confidence threshold for pruning. Default 0.25.}

\item{nbr_obs_leaf}{The minimum number of observations in a leaf node. Default 100.}
}
\value{
An object of class llm.cv, which is a list with the following components:
\item{foldpred}{a data frame with, per fold, predicted class membership probabilities for the left-out observations}
\item{pred}{a data frame with predicted class membership probabilities.}
\item{foldclass}{a data frame with, per fold, predicted classes for the left-out observations.}
\item{class}{a data frame with the predicted classes.}
\item{conf}{the confusion matrix which compares the real versus the predicted class memberships based on the class object.}
}
\description{
In \emph{v}-fold cross validation, the data are divided into \emph{v} subsets of
approximately equal size. Subsequently, one of the \emph{v} data parts is
excluded while the remaider of the data is used to create a logitleafmodel
object. Predictions are generated for the excluded data part. The process
is repeated \emph{v} times.
}
\examples{
## Load PimaIndiansDiabetes dataset from mlbench package
if (requireNamespace("mlbench", quietly = TRUE)) {
  library("mlbench")
}
data("PimaIndiansDiabetes")
## Create the LLM with 5-cv
Pima.llm <- llm.cv(X = PimaIndiansDiabetes[,-c(9)],Y = PimaIndiansDiabetes$diabetes, cv=5,
 threshold_pruning = 0.25,nbr_obs_leaf = 100)
}
\references{
Arno De Caigny, Kristof Coussement, Koen W. De Bock, A New Hybrid Classification Algorithm for Customer Churn Prediction Based on Logistic Regression and Decision Trees, European Journal of Operational Research (2018), doi: 10.1016/j.ejor.2018.02.009.
}
\seealso{
\code{\link{predict.llm}}, \code{\link{table.llm.html}}, \code{\link{llm}}
}
\author{
Arno De Caigny, \email{a.de-caigny@ieseg.fr}, Kristof Coussement, \email{k.coussement@ieseg.fr} and Koen W. De Bock, \email{kdebock@audencia.com}
}
