% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{RE}
\alias{RE}
\title{Random Effect Structure}
\usage{
RE(formula, var.cluster, var.time, ranef = NULL, add.time)
}
\arguments{
\item{formula}{formula indicating on which variable to stratify the residual variance and correlation (left hand side)
and variables influencing the residual variance and correlation (right hand side).##'}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{ranef}{[list] characteristics of the random effects}

\item{add.time}{not used.}
}
\value{
An object of class \code{CS} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure parametrized via random effects.
Can be stratified on a categorical variable.
}
\details{
A typical formula would be \code{~1}, indicating a variance constant over time and the same correlation between all pairs of times.
}
\examples{
RE(~1, var.cluster = "id", var.time = "time")
RE(~gender, var.cluster = "id", var.time = "time")
RE(gender~(1|id), var.time = "time")

}
\keyword{multivariate}
