% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverTlong.r
\name{Coveragelongmemory}
\alias{Coveragelongmemory}
\title{Calculate the coverage of several long-memory models}
\usage{
Coveragelongmemory(
  n,
  R,
  N,
  S,
  mu = 0,
  dist,
  method,
  B = NULL,
  nr.cores = 1,
  seed = 123,
  alpha,
  beta,
  start,
  sign = 0.05
)
}
\arguments{
\item{n}{(type: numeric) size of the simulated series.}

\item{R}{(type: numeric) number of realizations of the Monte Carlo experiments.}

\item{N}{(type: numeric) sample size of each block.}

\item{S}{(type: numeric) shifting places from block to block. Observe that the number of blocks M is determined by the following formula \eqn{M=\left\lfloor \frac{T-N}{S} + 1 \right\rfloor}, where \eqn{\left\lfloor . \right\rfloor} takes a single numeric argument \code{x} and returns a numeric vector containing the integers formed by truncating the values in \code{x} toward \code{0}.}

\item{mu}{(type: numeric) trend coefficient of the regression model.}

\item{dist}{(type: character) white noise distribution for calculating coverage, it includes the \code{"normal"}, \code{"exponential"} and \code{"uniform"} univariate distributions.}

\item{method}{(type: character) methods are asymptotic (\code{"asym"}), bootstrap percentile (\code{"boot"}) and bootstrap-t (\code{"boott"}).}

\item{B}{(type: numeric) the number of bootstrap replicates, NULL indicates the asymptotic method.}

\item{nr.cores}{(type: numeric) number of CPU cores to be used for parallel processing. 1 by default.}

\item{seed}{(type: numeric) random number generator seed to generate the bootstrap samples.}

\item{alpha}{(type: numeric) numeric vector with values to simulate the time varying autoregressive parameters of model LSAR(1), \eqn{\phi(u)}.}

\item{beta}{(type: numeric) numeric vector with values to simulate the time varying scale factor parameters of model LSAR(1), \eqn{\sigma(u)}.}

\item{start}{(type: numeric) numeric vector, initial values for parameters to run the model.}

\item{sign}{nominal significance level}
}
\value{
A data frame containing the following columns:
\itemize{
\item \code{n}: Size of each simulated series.
\item \code{method}: Statistical method used for simulation.
\item \code{coverage}: Proportion of true parameter values within the intervals.
\item \code{avg_width}: Average width of the intervals.
\item \code{sd_width}: Standard deviation of the interval widths.
}
}
\description{
Generates coverage metrics for a parameter of interest using a specified long-memory model.
}
\details{
This function estimates the parameters in the linear regression model for \eqn{t = 1, ..., T},
\deqn{Y_{t,T} = X_{t,T} \beta + \epsilon_{t,T},}
where a locally stationary fractional noise process (LSFN) is described by the equation:
\deqn{\epsilon_{t,T} = \sum_{j=0}^\infty \psi_j(u) \eta_{t-j}}
for u=t/T in [0,1], where \eqn{\psi_j(u) = \frac{\Gamma[j + d(u)]}{\Gamma[j+1] \Gamma[d(u)]}} and \eqn{d(u)} is the
smoothly varying long-memory coefficient. This model is referred to as locally stationary fractional noise (LSFN).

In this particular case, \eqn{d(u)} is modeled as a linear polynomial, and \eqn{\sigma(u)} as a quadratic polynomial.

Resampling methods evaluated:
\itemize{
\item asym: Asymptotic method that uses the asymptotic variance of the estimator, based
on the Central Limit Theorem, to construct confidence intervals under the
assumption of normality in large samples.
\item boot: Standard bootstrap that generates replicas of the estimator \eqn{\hat{\beta}} by resampling
the adjusted residuals \eqn{\hat{\epsilon}_t}. It approximates the distribution of the estimator by
the variability observed in the bootstrap replicas of \eqn{\hat{\beta}}.
\item boott: Adjusted bootstrap that scales the bootstrap replicas of the estimator
\eqn{\hat{\beta}} by its standard error, aiming to refine the precision of the confidence interval
and adjust for the variability in the parameter estimation.
}

For more details, see references.
}
\examples{
Coveragelongmemory(n=500,R=5,N=60,S=40,mu=0.5,dist="normal",method="asym",
beta=c(0.1,-2),alpha=c(0.15,0.25, 0.1),start = c(0.1,-2,0.15,0.2, 0.1))

}
\references{
Ferreira G., Mateu J., Vilar J.A., Muñoz J. (2020). Bootstrapping regression models with locally stationary disturbances. TEST, 30, 341-363.
}
