% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{Pv}
\alias{Pv}
\title{Proportion of vegetation or fractional vegetation cover}
\usage{
Pv(NDVI, minNDVI, maxNDVI)
}
\arguments{
\item{NDVI}{SpatRaster object, NDVI calculated from remote sensing imagery}

\item{minNDVI}{= 0.2 (Ref. Sobrino et al. 2004)}

\item{maxNDVI}{= 0.5 (Ref. Sobrino et al. 2004)}
}
\value{
SpatRaster
}
\description{
Calculation of the proportion of vegetation or fractional vegetation cover from NDVI
}
\examples{
NDVI <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NDVI) = runif(10000, min=0.02, max=0.8)
Pv(NDVI = NDVI, minNDVI = 0.2, maxNDVI = 0.5)
}
\references{
Sobrino, J.A., Jiménez-Muñoz, J.C. and Paolini, L., 2004. Land surface temperature retrieval from LANDSAT TM 5. Remote Sensing of environment, 90(4), pp.434-440.
}
