#' Resume Experiment Data
#'
#' Data from an experimental study in which researchers sent the resumes of fictitious
#' job applicants to potential employers. The first names of the fictitious applicants was
#' set randomly to sound either Black or white.
#'
#' @usage data("Callback")
#'
#' @docType data
#'
#' @format: `Callback`: A data frame with 4870 rows and 4 variables. Each row is one fictitious applicant
#' - name: first name of the fictitious job applicant
#' - sex: sex of applicant (female or male)
#' - callback: whether the potential employer called back to follow up. (1 = yes, 0 = no)
#' Another data frame, `Names_and_race`: which first names are associated with which race.
#'
#' @references
#' - Imai, Kosuke. 2017. Quantitative Social Science: An Introduction. Princeton University Press.  [URL](https://press.princeton.edu/books/hardcover/9780691167039/quantitative-social-science) from whence
#' these data were added to this package. In QSS, the data are called `resume`.
#' - Marianne Bertrand and Sendhil Mullainathan (2004) “Are Emily and Greg more employable than Lakisha and Jamal? A field experiment on labor market discrimination.” American Economic Review, vol. 94, no. 4, pp. 991–1013. doi: 10.3386/w9873
#' @name Callback
"Callback"
#' @name Callback
"Names_and_race"
