% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_slope_rose.R
\name{add_slope_rose}
\alias{add_slope_rose}
\alias{add_violin_ruler}
\title{Add a slope "rose" to a plot.}
\usage{
add_slope_rose(
  P,
  x = NULL,
  y = NULL,
  scale = 1/4,
  color = "red",
  keepers = c("both", "pos", "neg")
)

add_violin_ruler(
  P,
  x = NULL,
  y = NULL,
  width = 1/10,
  ticks = seq(0, 1, by = 0.1),
  ...
)
}
\arguments{
\item{P}{a ggplot2 object made by the ggplot2 or ggformula packages}

\item{x}{the x-position of the rose. This will be assigned automatically if \code{x} isn't specified.}

\item{y}{the y-position of the rose, just like \code{x}.}

\item{scale}{the size of the rose as a fraction of the plot area covered (default 1/4)}

\item{color}{text string (e.g. \code{"blue"}) for the rose}

\item{keepers}{whether to show \code{"both"} positive and negative slopes or just show the \code{"pos"} or the \code{"neg"}}

\item{width}{for rulers, the distance between tick marks (in native units, where
categories are separated by a distance of 1.)}

\item{ticks}{Integers, typically \code{0:5}, that label the ticks.}

\item{\ldots}{additional graphical parameters, e.g. \code{color = "blue"}}
}
\value{
A ggplot graphics object
}
\description{
To guide a reader in quantifying the slope of components of an x-y graph, a "slope rose" is helpful.
Several radiating lines are drawn, each marked with a numerical slope. A suitable choice of slopes
is made automatically, based on the x- and y- scale of the plot.
}
\details{
For the ruler, x gives the position of the root of the ruler, with
the rest of the ruler moving off to the left. (For vertically oriented rulers, use
a negative width.)
}
\note{
Use the pipe operator to send a previously made plot to have a rose added. Don't use the \code{{ggplot2}}
\code{+} connector.
}
\examples{
mtcars |> point_plot(mpg ~ hp, annot="model") |> add_slope_rose()
mtcars |> point_plot(wt ~ hp) |> add_slope_rose(keepers="pos", color="blue", x=100, scale=.5 )

}
