% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoconv.R
\name{autoconv}
\alias{autoconv}
\title{Auto Convolution}
\usage{
autoconv(x)
}
\arguments{
\item{x}{a real or complex vector}
}
\value{
The linear auto convolution of a given vector with itself,
        which is equivalent with its inner product.
}
\description{
\code{autoconv} computes the linear convolution of a numeric vector with itself.
It is based on the  \code{fft} function and is twicked to achieve maximum performance.
}
\details{
The speed of calculation for the linear convolution depends upon the number of factors
         in the number representing the vector length. This implementation maximizes calculation speed for vectors
         of dyadic length, or lengths with a single factor.
}
\examples{

 v <- rnorm(n = 64)
vv <- autoconv(x = v)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{fft}}, \code{\link{convolve}}.
}
\author{
Alessandro Cardinali
}
