% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3_1t.R
\name{step3_1t}
\alias{step3_1t}
\title{Result function for latent regression}
\usage{
step3_1t(eap, cep, covar, K, method)
}
\arguments{
\item{eap}{expected a posteriori.}

\item{cep}{classification error probabilities.}

\item{covar}{covariances.}

\item{K}{number of attributes.}

\item{method}{the sample-level \code{"SL"} or the posterior distribution level \code{"PDL"} correction weights.}
}
\value{
A data.frame containing the following columns:
\describe{
\item{Attribute}{The attribute.}
\item{Estimate}{Estimated regression coefficient.}
\item{odds.ratio}{Odds ratio.}
\item{d}{Effect size.}
\item{SE}{Standard error.}
\item{CI.95}{95\% confidence interval.}
\item{z.value}{Wald test z-statistics.}
\item{p.2tailed}{Two-tailed p-value.}
\item{p.1tailed}{One-tailed p-value.}
}
}
\description{
Result function for latent regression.Details can be found in Iaconangelo (2017).
}
\examples{
# ---- Runable example (using simulated CEP) ----
if (requireNamespace("GDINA", quietly = TRUE)) {
  library(GDINA)
  dat <- sim10GDINA$simdat
  Q <- matrix(c(1,0,0,
                0,1,0,
                0,0,1,
                1,0,1,
                0,1,1,
                1,1,0,
                0,0,1,
                1,0,0,
                1,1,1,
                1,0,1), byrow = TRUE, ncol = 3)
  fit.object <- GDINA(dat, Q = Q, model = "GDINA", att.dist = "independent", verbose = FALSE)
  cep_test <- list(SL.k = list(), PDL.k = list())
  for (i in 1:3) {
    cep_test$SL.k[[i]] <- matrix(runif(4, min = 0, max = 1), nrow = 2)
    cep_test$PDL.k[[i]] <- lapply(1:1000, function(j) matrix(runif(4, min = 0, max = 1), nrow = 2))
  }
  eap <- personparm(fit.object, what = "EAP")
  covar_test <- matrix(runif(3000, min = -2, max = 2), nrow = 1000)
  K <- 3
  result_SL <- step3_1t(eap = eap, cep = cep_test, covar = covar_test, K = K, method = "SL")
  result_PDL <- step3_1t(eap = eap, cep = cep_test, covar = covar_test, K = K, method = "PDL")
}

# ---- Not recommended to run (depends on CEP() output) ----
\dontrun{
fit.object <- GDINA(dat = dat, Q = Q, model = "GDINA", att.dist = "independent", verbose = FALSE)
cep <- CEP_1t(fit.object)
eap <- personparm(fit.object, what = "EAP")
out_PDL <- step3_1t(eap, Q, cep, covar, K, "PDL")
out_SL <- step3_1t(eap, Q, cep, covar, K, "SL")
}

}
\references{
Iaconangelo, C. (2017). Uses of classification error probabilities in the three-step approach to estimating cognitive diagnosis models (Doctoral dissertation). https://rucore.libraries.rutgers.edu/rutgers-lib/55495/PDF/1/play/
}
