% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_Matrix_Functions.R
\name{graph_based_covariance_construction}
\alias{graph_based_covariance_construction}
\title{Constructing covariance matrix from local family graph}
\usage{
graph_based_covariance_construction(
  pid,
  cur_proband_id,
  cur_family_graph,
  h2,
  add_ind = TRUE
)
}
\arguments{
\item{pid}{Name of column of personal ID}

\item{cur_proband_id}{id of proband}

\item{cur_family_graph}{local graph of current proband}

\item{h2}{liability scale heritability}

\item{add_ind}{whether to add genetic liability of the proband or not. Defaults to true.}
}
\value{
list with two elements. The first element is temp_tbl, which contains the id of
the current proband, the family ID and the lower and upper thresholds. The second element,
cov, is the covariance matrix of the local graph centered on the current proband.
}
\description{
Function that constructs the genetic covariance matrix given a graph around a proband
and extracts the threshold information from the graph.
}
\examples{
fam <- data.frame(
  id = c("pid", "mom", "dad", "pgf"),
  dadcol = c("dad", 0, "pgf", 0),
  momcol = c("mom", 0, 0, 0))

thresholds <- data.frame(
  id = c("pid", "mom", "dad", "pgf"),
  lower = c(-Inf, -Inf, 0.8, 0.7),
  upper = c(0.8, 0.8, 0.8, 0.7))

graph <- prepare_graph(fam, icol = "id", fcol = "dadcol",
 mcol = "momcol", node_attributes = thresholds)

graph_based_covariance_construction(pid = "id",
                                    cur_proband_id = "pid",
                                    cur_family_graph = graph,
                                    h2 = 0.5)

}
