% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_depth.R
\name{get_real_depths}
\alias{get_real_depths}
\title{Effective fuel layers depth}
\usage{
get_real_depths (effective_fbh, step=1, min_height=1.5, verbose=TRUE)
}
\arguments{
\item{effective_fbh}{tree metrics with the recalculated base height of fuel layers after considering distances greater than any number of height bin steps
(output of [get_real_fbh()] function).An object of the class text.}

\item{step}{Numeric value for the actual height bin step (in meters).}

\item{min_height}{Numeric value for the actual minimum base height (in meters).}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving new fuel layers depth after considering distances greater than the actual height bin step.
}
\description{
This function recalculates fuel layers depth after considering distances greater than the actual height bin step.
}
\details{
# List of tree metrics:
\itemize{
\item treeID: tree ID with strings and numeric values
\item treeID1: tree ID with only numeric values
\item dist: Distance between consecutive fuel layers (m)
\item Hdist - Height of the distance between consecutive fuel layers (m)
\item Hcbh - Base height of each fuel separated by a distance greater than the certain number of steps
\item dptf - Depth of fuel layers (m) after considering distances greater than the actual height bin step
\item Hdptf - Height of the depth of fuel layers (m) after considering distances greater than the actual height bin step
\item max_height - Maximum height of the tree profile
}
}
\examples{
library(magrittr)
library(tidyr)
library(dplyr)

# Before running this example, make sure to run get_real_fbh().
if (interactive()) {
effective_fbh <- get_real_fbh()
LadderFuelsR::effective_fbh$treeID <- factor(LadderFuelsR::effective_fbh$treeID)

trees_name1 <- as.character(effective_fbh$treeID)
trees_name2 <- factor(unique(trees_name1))

depth_metrics_corr_list <- list()

for (i in levels(trees_name2)){
# Filter data for each tree
tree3 <- effective_fbh |> dplyr::filter(treeID == i)
# Get real depths for each tree
depth_metrics_corr <- get_real_depths(tree3, step=1, min_height=1.5,verbose=TRUE)
depth_metrics_corr_list[[i]] <- depth_metrics_corr
}

# Combine depth values for all trees
effective_depth <- dplyr::bind_rows(depth_metrics_corr_list)

# Reorder columns
original_column_names <- colnames(effective_depth)

# Specify prefixes
desired_order <- c("treeID", "Hcbh", "dptf", "dist", "Hdist", "Hdptf", "max_height")

# Identify unique prefixes
prefixes <- unique(sub("^([a-zA-Z]+).*", "\\\\1", original_column_names))
# Initialize vector to store new order
new_order <- c()

# Loop over desired order of prefixes
for (prefix in desired_order) {
  # Find column names matching the current prefix
  matching_columns <- grep(paste0("^", prefix), original_column_names, value = TRUE)
  # Append to the new order
  new_order <- c(new_order, matching_columns)
}
effective_depth <- effective_depth[, new_order]
}
}
\seealso{
\code{\link{get_renamed0_df}}

\code{\link{get_real_fbh}}
}
\author{
Olga Viedma, Carlos Silva, JM Moreno and A.T. Hudak
}
