% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indepchisq.test.R
\name{indepchisq.test}
\alias{indepchisq.test}
\title{Chi-squared Independence Test for Categorical Data.}
\usage{
indepchisq.test(Oij, x, y, alpha = 0.05, plot = TRUE, lwd = 1)
}
\arguments{
\item{Oij}{observed frequencies. A numeric matrix, a table or a data.frame with the
observed frequencies can be passed. If missing, arguments \code{x} and \code{y} must be supplied.}

\item{x}{a vector (numeric or character) or factor with the first categorical variable.}

\item{y}{a vector (numeric or character) or factor with the second categorical variable. It should be of the same
length as \code{x}.}

\item{alpha}{a single number in (0,1), significance level.}

\item{plot}{a logical indicating whether to plot the rejection region and p-value.}

\item{lwd}{a single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom of the statistic's distribution.}
\item{p.value}{the p-value of the test.}
\item{estimate}{a numeric matrix with the estimated frequencies Eij.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
\item{obs.freq}{a numeric matrix with the observed frequencies Oij.}
}
\description{
\code{indepchisq.test} allows to computes Chi-squared independence hypothesis test for two categorical values.
}
\details{
The expected frequencies are calculated as follows
\deqn{E_{ij}=\frac{n_{i\bullet}\times n_{\bullet j}}{n},} and the test statistic
is given by \deqn{T = \sum_{i,j} \frac{(n_{ij} - E_{ij})^2}{E_{ij}},}
\eqn{T \in \chi^2_{(r-1)(s-1)}}, where \eqn{n} is the number of observations, \eqn{n_{i\bullet}}
 is the marginal frequency of category i of variable x, \eqn{n_{\bullet j}}
is the marginal frequency of category j of variable y, r is the number of categories in
variable x and s the number of categories in variable y.

The null hypothesis is rejected when \eqn{T > \chi^2_{(r-1)(s-1),1-\alpha}}, where \eqn{\chi^2_{(r-1)(s-1),1-\alpha}}
is the \eqn{1-\alpha} quantile of a \eqn{\chi^2} distribution with \eqn{(r-1)(s-1)} degrees of freedom.
}
\examples{
Oij <- matrix(c( 20,    8,
                934, 1070,
                113,   92), ncol = 2, byrow = TRUE)
indepchisq.test(Oij)
}
