% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negativebinomial.R
\name{plotNegBinom}
\alias{plotNegBinom}
\title{Probability Mass and/or Distribution Function Representations associated with a Negative Binomial Distribution}
\usage{
plotNegBinom(n, p, type = "b", col = "grey")
}
\arguments{
\item{n}{the number of successful Bernoulli trials.}

\item{p}{the probability of success associated with the Bernoulli trial.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for probability mass function and distribution function representations together,
"d" for distribution function representation and "p" for probability mass function representation.}

\item{col}{a single colour associated with the probability mass function representation; default to "grey".}
}
\value{
A matrix containing the probability mass and the distribution function associated with each point
of the support of a Negative Binomial distribution with parameters \code{n} and \code{p}.
}
\description{
\code{plotNegBinom} represents the probability mass and/or the distribution function associated with a Negative Binomial
 distribution with certain parameters \code{n} and \code{p}.
}
\details{
Note that if \code{n=1}, the Negative Binomial distribution is also known as Geometric distribution.
}
\examples{
n=3;p=0.3
plotNegBinom(n,p,type="d")
plotNegBinom(n,p,type="p",col="pink")
plotNegBinom(n,p)
}
