% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lb.R
\name{predict.lb}
\alias{predict.lb}
\title{Predict method for lb objects}
\usage{
\method{predict}{lb}(object, newx, t, type = c("fit", "coefficients"), ...)
}
\arguments{
\item{object}{lb object}

\item{newx}{New data matrix that each row is a data or a vector. If missing,
type switched to coefficients}

\item{t}{The parmeter for object to determin which coeffiecients used for prediction.
Linear interpolation is used if t is not in object\$t. 
If missing, all the coeffiecients along the path is used to predict.}

\item{type}{To predict response of newx or just fit coeffients on the path.}

\item{\dots}{Additonal arguments for generic predict.}
}
\value{
A list containing t and other variables. For type="fit", the rediction response
"fit" is returned. For "binomial", a vector of the probabilities for newx 
falling into class +1 is redurned. For "multinomial", a matrix with each column means
the probabilities for newx falling into the corresponding class. If type="coefficients"
coefficients "beta" and intercepts "a0" are returned.
}
\description{
Predict response variable for new data given a lb object
}
\details{
The default plot uses the fraction of L1 norm as the x. 
For multinomial case, the sum of absolute values of different class's 
coefficients are caculated to represent each variable.
The intercept term is not ploted
}
\author{
Feng Ruan, Jiechao Xiong and Yuan Yao
}
\keyword{methods}
