% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Time_col.R
\name{add_Time_col}
\alias{add_Time_col}
\title{Create a Time-of-Day column in the dataset}
\usage{
add_Time_col(
  dataset,
  Datetime.colname = Datetime,
  Time.colname = Time,
  output.dataset = TRUE
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}. Must
be of type \code{POSIXct}.}

\item{Time.colname}{Name of the newly created column. Expects a \code{symbol}. The
default(\code{Time}) works well with other functions in \link{LightLogR}.
Will overwrite existing columns of identical name.}

\item{output.dataset}{should the output be a \code{data.frame} (Default \code{TRUE}) or
a vector with \code{hms} (\code{FALSE}) times? Expects a \code{logical} scalar.}
}
\value{
a \code{data.frame} object identical to \code{dataset} but with the added
column of Time-of-Day data, or a \code{vector} with the Time-of-Day-data
}
\description{
Create a Time-of-Day column in the dataset
}
\examples{
sample.data.environment \%>\% add_Time_col()

}
