% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_barroso.R
\name{barroso_lighting_metrics}
\alias{barroso_lighting_metrics}
\title{Circadian lighting metrics from Barroso et al. (2014)}
\usage{
barroso_lighting_metrics(
  Light.vector,
  Time.vector,
  epoch = "dominant.epoch",
  loop = FALSE,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct}, \link[hms]{hms},
\link[lubridate]{duration}, or \link[base]{difftime}.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{loop}{Logical. Should the data be looped? Defaults to \code{FALSE}.}

\item{na.rm}{Logical. Should missing values (NA) be removed for the calculation?
Defaults to \code{FALSE}. If \code{TRUE}, for the calculation of \code{bright_cluster} and
\code{dark_cluster}, missing values will be replaced by 0
(see \code{\link{period_above_threshold}}).}

\item{as.df}{Logical. Should a data frame be returned? If \code{TRUE}, a data
frame with seven columns will be returned. Defaults to \code{FALSE}.}
}
\value{
List or dataframe with the seven values: \code{bright_threshold}, \code{dark_threshold},
\code{bright_mean_level}, \code{dark_mean_level}, \code{bright_cluster}, \code{dark_cluster},
\code{circadian_variation}. The output type of \code{bright_cluster}, \code{dark_cluster},
is a \link[lubridate]{duration} object.
}
\description{
This function calculates the metrics proposed by Barroso et al. (2014)
for light-dosimetry in the context of research on the non-visual effects of light.
The following metrics are calculated:
}
\details{
\describe{
\item{\code{bright_threshold}}{The maximum light intensity for which at least six
hours of measurements are at the same or higher level.}
\item{\code{dark_threshold}}{The minimum light intensity for which at least eight
hours of measurements are at the same or lower level.}
\item{\code{bright_mean_level}}{The 20\% trimmed mean of all light intensity measurements
equal or above the \code{bright_threshold}.}
\item{\code{dark_mean_level}}{The 20\% trimmed mean of all light intensity measurements
equal or below the \code{dark_threshold}.}
\item{\code{bright_cluster}}{The longest continuous time interval above the \code{bright_threshold}.}
\item{\code{dark_cluster}}{The longest continuous time interval below the \code{dark_threshold}.}
\item{\code{circadian_variation}}{A measure of periodicity of the daily lighting
schedule over a given set of days. Calculated as the coefficient of variation
of input light data.
}
}
}
\examples{

dataset1 <-
  tibble::tibble(
    Id = rep("B", 60 * 24),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(0:(60*24-1)),
    MEDI = c(rep(sample(seq(0,1,0.1), 60*8, replace = TRUE)), 
             rep(sample(1:1000, 16, replace = TRUE), each = 60))
  )

dataset1 \%>\%
  dplyr::reframe(barroso_lighting_metrics(MEDI, Datetime, as.df = TRUE))
  
}
\references{
Barroso, A., Simons, K., & Jager, P. de. (2014). Metrics of circadian
lighting for clinical investigations. \emph{Lighting Research & Technology},
46(6), 637–649. \doi{10.1177/1477153513502664}

Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
