% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_duration_above_threshold.R
\name{duration_above_threshold}
\alias{duration_above_threshold}
\title{Duration above/below threshold or within threshold range}
\usage{
duration_above_threshold(
  Light.vector,
  Time.vector,
  comparison = c("above", "below"),
  threshold,
  epoch = "dominant.epoch",
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct}, \link[hms]{hms},
\link[lubridate]{duration}, or \link[base]{difftime}.}

\item{comparison}{String specifying whether the time above or below threshold
should be calculated. Can be either \code{"above"} (the default) or \code{"below"}. If
two values are provided for \code{threshold}, this argument will be ignored.}

\item{threshold}{Single numeric value or two numeric values specifying the
threshold light level(s) to compare with. If a vector with two values is provided,
the time within the two thresholds will be calculated.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{na.rm}{Logical. Should missing values (NA) be removed for the calculation?
Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should a data frame with be returned? If \code{TRUE}, a data
frame with a single column named \verb{duration_\{comparison\}_\{threshold\}} will be returned.
Defaults to \code{FALSE}.}
}
\value{
A \link[lubridate]{duration} object as single value, or single column data frame.
}
\description{
This function calculates the duration spent above/below a specified threshold
light level or within a specified range of light levels.
}
\examples{
N <- 60
# Dataset with epoch = 1min
dataset1 <-
  tibble::tibble(
    Id = rep("A", N),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(1:N),
    MEDI = sample(c(sample(1:249, N / 2), sample(250:1000, N / 2))),
  )
# Dataset with epoch = 30s
dataset2 <-
  tibble::tibble(
    Id = rep("B", N),
    Datetime = lubridate::as_datetime(0) + lubridate::seconds(seq(30, N * 30, 30)),
    MEDI = sample(c(sample(1:249, N / 2), sample(250:1000, N / 2))),
  )
dataset.combined <- rbind(dataset1, dataset2)

dataset1 \%>\%
  dplyr::reframe("TAT >250lx" = duration_above_threshold(MEDI, Datetime, threshold = 250))

dataset1 \%>\%
  dplyr::reframe(duration_above_threshold(MEDI, Datetime, threshold = 250, as.df = TRUE))

# Group by Id to account for different epochs
dataset.combined \%>\%
  dplyr::group_by(Id) \%>\%
  dplyr::reframe("TAT >250lx" = duration_above_threshold(MEDI, Datetime, threshold = 250))

}
\references{
Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
