% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_Time.R
\name{filter_Time}
\alias{filter_Time}
\title{Filter Times in a dataset.}
\usage{
filter_Time(
  dataset,
  Datetime.colname = Datetime,
  start = NULL,
  end = NULL,
  length = NULL
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}. Must
be of type \code{POSIXct}.}

\item{start, end, length}{a \code{character} scalar in the form of \code{"hh-mm-ss"}
giving the respective start, end, or length for the filtered dataframe. The
input can also come from a \code{POSIXct} datetime, where only the time
component will be used.
\itemize{
\item If one or both of start/end are not provided, the times will be taken from the respective extreme values of the \code{dataset}.
\item If \code{length} is provided and one of start/end is not, the other will be calculated based on the given value.
\item If \code{length} is provided and both of start/end are not, the time from the
respective start is taken.
}}
}
\value{
a \code{data.frame} object identical to \code{dataset} but with only the
specified Times.
}
\description{
Filter Times in a dataset.
}
\examples{
sample.data.environment \%>\%
filter_Time(start = "4:00:34", length = "12:00:00") \%>\%
dplyr::pull(Time) \%>\% range() \%>\% hms::as_hms()
}
\seealso{
Other filter: 
\code{\link{filter_Datetime}()}
}
\concept{filter}
