% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_partial_data.R
\name{remove_partial_data}
\alias{remove_partial_data}
\title{Remove groups that have too few data points}
\usage{
remove_partial_data(
  dataset,
  Variable.colname = Datetime,
  threshold.missing = 0.2,
  by.date = FALSE,
  Datetime.colname = Datetime,
  show.result = FALSE,
  handle.gaps = FALSE
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a dataframe. If not imported
by LightLogR, take care to choose sensible variables for the
Datetime.colname and Variable.colname.}

\item{Variable.colname}{Column name that contains the variable for which to
assess sufficient datapoints. Expects a symbol. Needs to be part of the
dataset. Default is \code{Datetime}, which makes only sense in the presence of
single data point groups that need to be removed.}

\item{threshold.missing}{either
\itemize{
\item percentage of missing data, before that group gets removed. Expects a numeric scalar.
\item duration of missing data, before that group gets removed. Expects either a \code{\link[lubridate:duration]{lubridate::duration()}} or a character that can be converted to one, e.g., "30 mins".
}}

\item{by.date}{Logical. Should the data be (additionally) grouped by day?
Defaults to \code{FALSE}. Additional grouping is not persitant beyond the
function call.}

\item{Datetime.colname}{Column name that contains the datetime. Defaults to
"Datetime" which is automatically correct for data imported with LightLogR.
Expects a symbol. Needs to be part of the dataset. Must be of type POSIXct.}

\item{show.result}{Logical, whether the output of the function is summary of
the data (TRUE), or the reduced dataset (FALSE, the default)}

\item{handle.gaps}{Logical, whether the data shall be treated with
\code{\link[=gap_handler]{gap_handler()}}. Is set to \code{FALSE} by default. If \code{TRUE}, it will be used
with the argument \code{full.days = TRUE}.}
}
\value{
if \code{show.result = FALSE}(default), a reduced dataframe without the
groups that did not have sufficient data
}
\description{
This function removes groups from a dataframe that do not have sufficient
data points. Groups of one data point will automatically be removed. Single
data points are common after using \code{\link[=aggregate_Datetime]{aggregate_Datetime()}}.
}
\examples{
#create sample data with gaps
gapped_data <-
  sample.data.environment |>
  dplyr::filter(MEDI < 30000)

#check their status, based on the MEDI variable
gapped_data |> remove_partial_data(MEDI, handle.gaps = TRUE, show.result = TRUE)

#the function will produce a warning if implicit gaps are present
gapped_data |> remove_partial_data(MEDI, show.result = TRUE)

#one group (Environment) does not make the cut of 20\% missing data
gapped_data |> remove_partial_data(MEDI, handle.gaps = TRUE) |> dplyr::count(Id)
#for comparison
gapped_data |> dplyr::count(Id)
#If the threshold is set differently, e.g., to 2 days allowed missing, results vary
gapped_data |>
  remove_partial_data(MEDI, handle.gaps = TRUE, threshold.missing = "2 days") |>
  dplyr::count(Id)

#The removal can be automatically switched to daily detections within groups
gapped_data |>
 remove_partial_data(MEDI, handle.gaps = TRUE, by.date = TRUE, show.result = TRUE) |>
 head()
}
