% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_sequences.probability.R
\name{truncate_sequences.probability}
\alias{truncate_sequences.probability}
\title{Truncate DNA Sequences at Specified Probability that All Bases were Called Correctly}
\usage{
truncate_sequences.probability(sequences, quality_scores, threshold = 0.5)
}
\arguments{
\item{sequences}{A character vector of DNA sequences to truncate.}

\item{quality_scores}{A character vector of DNA sequence quality scores encoded in Sanger format.}

\item{threshold}{Numeric. The probability threshold used for truncation. The default is \code{0.5} (\emph{i.e.}, each trimmed sequence has a greater than 50\% probability that all bases were called correctly).}
}
\value{
A list containing two elements. The first element is a character vector of truncated DNA sequences, and the second element is a character vector of quality scores which have been truncated to their corresponding truncated DNA sequences.
}
\description{
Calculates the cumulative probability that all bases were called correctly along each DNA sequence and truncates the DNA sequence immediately prior to the first occurrence of a probability being equal to or less than a specified value.
}
\examples{
truncate_sequences.probability(sequences=c("ATATAGCGCG","TGCCGATATA","ATCTATCACCGC"),
                               quality_scores=c("989!.C;F@\"","A((#-#;,2F","HD8I/+67=1>?"),
                               threshold=0.5)
}
\seealso{
\code{\link[=truncate_sequences.length]{truncate_sequences.length}} for truncating DNA sequences to a specified length. \cr
\code{\link[=truncate_sequences.quality_score]{truncate_sequences.quality_score}} for truncating DNA sequences by Phred quality score.
}
