% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_modularity.R
\name{new_modularity}
\alias{new_modularity}
\title{Calculate the modularity}
\usage{
new_modularity(init_list, WL)
}
\arguments{
\item{init_list}{A list with N+2 elements, the former N as modality private sub-matrices, the Nth as the shared sub-matrix and the last one as the current loss}

\item{WL}{A list of similarity matrices}
}
\value{
A single value indicating the mudularity of current factorization and clustering
}
\description{
A function to calculate the modularity for weighted graph
}
\examples{

WL <- simu_data_gen()
WL[[1]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[1]]),Standard_Normalization(WL[[1]])))
WL[[2]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[2]]),Standard_Normalization(WL[[2]])))
new_WL_list <- initialize_WL(WL)
init_list <- initialization(new_WL_list,5)
res <- M2SMJF(WL,0.25,10^-4,5)
init_list <- res[[1]]
modularity <- new_modularity(init_list,WL)
}
\author{
Xiaoyao Yin
}
