% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crimmix_data_gen.R
\name{crimmix_data_gen}
\alias{crimmix_data_gen}
\title{Generate the simulated dataset with three modalities with the package crimmix}
\usage{
crimmix_data_gen(nclust=4, n_byClust=c(10,20,5,25),
feature_nums=c(1000,500,5000), noises=c(0.5,0.01,0.3),props=c(0.005,0.01,0.02))
}
\arguments{
\item{nclust}{number of clusters}

\item{n_byClust}{number of samples per cluster}

\item{feature_nums}{number of features in each modality}

\item{noises}{percentage of noise adding to each modality}

\item{props}{proportion of cluster related features in each modality}
}
\value{
res, a list of length 2, where the first element is a list of simulated data, while the second element is a vector indicating the true label of each sample
}
\description{
Generate the simulated dataset with three modalities with the package crimmix
}
\examples{
crimmix_data <- crimmix_data_gen(nclust=4, n_byClust=c(10,20,5,25),
feature_nums=c(1000,500,5000), noises=c(0.5,0.01,0.3),props=c(0.005,0.01,0.02))
}
