% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ModelEstimation.R
\name{generate_MAPC_formula}
\alias{generate_MAPC_formula}
\title{Generate MAPC formula for INLA}
\usage{
generate_MAPC_formula(
  df,
  APC_format,
  response,
  stratify_var,
  age = "age",
  period = "period",
  cohort = "cohort",
  intercept = FALSE,
  apc_prior = "rw1",
  apc_hyper = NULL,
  random_term = TRUE,
  extra.fixed = NULL,
  extra.random = NULL,
  extra.models = NULL,
  extra.hyper = NULL
)
}
\arguments{
\item{df}{Data frame for which MAPC models should be fit}

\item{APC_format}{A string where lower-case letters indicate stratum-specific time effects and upper-case letters indicate shared time effects.}

\item{response}{A string, name of the column in \code{df} that represents the response variable.}

\item{stratify_var}{Stratification variable. At least one time effect should be stratum-specific, and at least one should be shared.}

\item{age}{Name of age column}

\item{period}{Name of period column}

\item{cohort}{Name of cohort column}

\item{intercept}{Boolean, indicating if an overall intercept should be included in the formula.\cr\strong{Defaults to TRUE (optional).}}

\item{apc_prior}{Which prior model to use for the time effects.\cr\strong{Defaults to "rw1" (optional).}}

\item{apc_hyper}{If the user wants non-default hyperpriors for the random time effects, this can be achieved by passing the entire
prior specification as a string. If e.g. \code{hyper =  list(theta = list(prior="pc.prec", param=c(0.5,0.01)))} is desired, pass the string "\code{list(theta = list(prior="pc.prec", param=c(0.5,0.01)))}" to this argument.}

\item{random_term}{Indicator, indicating if a random term should be included in the model.\cr\strong{Defaults to TRUE (optional).}}

\item{extra.fixed}{Name of additional fixed effects.\cr\strong{Defaults to NULL (optional).}}

\item{extra.random}{Name of additional random effects.\cr\strong{Defaults to NULL (optional).}}

\item{extra.models}{Models for additional random effects. Supported \code{INLA} models include \code{'iid'}, \code{'rw1'} and \code{'rw2'}.\cr\strong{Defaults to NULL (optional).}}

\item{extra.hyper}{If the user wants non-default hyperpriors for the additional random effects, this can be achieved by passing the entire
prior specification as a string. If e.g. \code{hyper =  list(theta = list(prior="pc.prec", param=c(0.5,0.01)))} is desired, pass the string "\code{list(theta = list(prior="pc.prec", param=c(0.5,0.01)))}" to this argument.}
}
\value{
A formula object that can be passed to INLA to fit the desired MAPC model.
}
\description{
Based on APC-format, generate the proper formula to pass to INLA for fitting MAPC models.
}
