% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_counts_with_mean}
\alias{plot_counts_with_mean}
\title{Plot heatmap of observation counts with mean overlay, optionally stratified}
\usage{
plot_counts_with_mean(
  data,
  x,
  y,
  stratify_by = NULL,
  for_each = NULL,
  title = NULL,
  subtitle = NULL,
  heatmap_legend = "Count",
  mean_legend = "Mean",
  viridis_color_option = "D",
  mean_color = "coral"
)
}
\arguments{
\item{data}{Data frame containing all input variables.}

\item{x}{Variable in \code{data} whose values define the x-axis for counts.}

\item{y}{Variable in \code{data} whose values define the y-axis for counts, and for which the mean is computed for each value for \code{x}.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, counts and means are computed for each level of \code{stratify_by},
and separate heatmaps are generated per level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable.
If supplied, separate plot windows are created per level of \code{for_each}.}

\item{title}{(Optional) Plot title; defaults to \code{NULL}, in which case a title
of the form "\<Y\> distribution across \<X\>" is used.}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL}, or to
"\<for_each\>: \<level\>" when \code{for_each} is supplied.}

\item{heatmap_legend}{(Optional) Label for the heatmap legend; defaults to "Count".}

\item{mean_legend}{(Optional) Label for the overlay mean line legend; defaults to "Mean".}

\item{viridis_color_option}{(Optional) Option for color gradient; defaults to "D".
Options are "A", "B", "C", "D", E", "F", "G", "H".
See \pkg{viridis} for information, or experiment yourself.}

\item{mean_color}{(Optional) Color for the overlay mean line; defaults to "coral".}
}
\value{
If \code{for_each} is not supplied, a \code{\link[ggplot2]{ggplot}} object showing a
heatmap of counts with a mean overlay line, optionally faceted by \code{stratify_by}.
If \code{for_each} is supplied, a named list of such plots.
}
\description{
Computes counts of observations for each combination of two variables and displays
them as a heatmap, with an overlaid line showing the mean of the second variable
across the first. If a stratification variable is provided, observations are counted per strata and strata-specific heatmaps are displayed in individual panels.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Heatmap of counts by age vs. period with mean age overlay
plot_counts_with_mean(toy_data, x = period, y = age)
# Heatmap of counts by age vs. period with mean age overlay, stratified by education
plot_counts_with_mean(toy_data, x = period, y = age,
                      stratify_by = education)
# Heatmap of counts by age vs. period with mean age overlay, stratified by education, for each sex
plot_counts_with_mean(toy_data, x = period, y = age,
                      stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_counts_1D}}, \code{\link{plot_counts_2D}},
\code{\link{plot_binned_counts}}, \code{\link[ggplot2]{ggplot}}
}
