% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{devdev}
\alias{devdev}
\title{Dev-dev plot for comparing deviance contributions from two models}
\usage{
devdev(mod1, mod2, dev.type = "resdev", n.iter = 2000, n.thin = 1, ...)
}
\arguments{
\item{mod1}{First model for which to plot deviance contributions}

\item{mod2}{Second model for which to plot deviance contributions}

\item{dev.type}{\emph{STILL IN DEVELOPMENT FOR MBNMAdose!} Deviances to plot - can be either residual
deviances (\code{"resdev"}, the default) or deviances (\code{"dev"})}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}

\item{...}{Arguments to be sent to \code{ggplot2::geom_point()} or \code{ggplot2::geom_boxplot}}
}
\description{
Plots the deviances of two model types for comparison. Often used to assess
consistency by comparing consistency (NMA or MBNMA) and unrelated mean effects (UME)
models (see \insertCite{pedder2021cons;textual}{MBNMAdose}). Models must be run
on the \emph{same set of data} or the deviance comparisons will not be valid.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

# Run an poorly fitting linear dose-response
lin <- mbnma.run(network, fun=dpoly(degree=1))

# Run a better fitting Emax dose-response
emax <- mbnma.run(network, fun=demax())

# Run a standard NMA with unrelated mean effects (UME)
ume <- nma.run(network, UME=TRUE)

# Compare residual deviance contributions from linear and Emax
devdev(lin, emax) # Suggests model fit is very different

# Compare deviance contributions from Emax and UME
devdev(emax, ume) # Suggests model fit is similar

}

}
