% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrCompTest.R
\name{corrCompTest}
\alias{corrCompTest}
\title{Carry out a test of MCAR checking compatibility of correlation matrices.}
\usage{
corrCompTest(X, B)
}
\arguments{
\item{X}{The dataset with incomplete data.}

\item{B}{The bootstrap sample \eqn{B} for the bootstrap test.}
}
\value{
The p-value of the test of MCAR based on correlation matrices, as outlined in
Algorithm 1 in \insertCite{BB2024;textual}{MCARtest}.
}
\description{
This is the implementation of Algorithm 1 in \insertCite{BB2024;textual}{MCARtest}.
}
\examples{
library(MASS)
alpha = 0.05
B = 20
m = 500

SigmaS=list() #Random 2x2 correlation matrices (necessarily consistent)
for(j in 1:3){
x=runif(2,min=-1,max=1); y=runif(2,min=-1,max=1)
SigmaS[[j]]=cov2cor(x\%*\%t(x) + y\%*\%t(y))
}

X1 = mvrnorm(m, c(0,0), SigmaS[[1]])
X2 = mvrnorm(m, c(0,0), SigmaS[[2]])
X3 = mvrnorm(m, c(0,0), SigmaS[[3]])
columns = c("X1","X2","X3")
X = data.frame(matrix(nrow = 3*m, ncol = 3))
X[1:m, c("X1", "X2")] = X1
X[(m+1):(2*m), c("X2", "X3")] = X2
X[(2*m+1):(3*m), c("X1", "X3")] = X3
X = as.matrix(X)

corrCompTest(X, B)
}
\references{
\insertRef{BB2024}{MCARtest}
}
