% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{roc}
\alias{roc}
\title{Receiver operator characteristic}
\usage{
roc(response, group, levels, state)
}
\arguments{
\item{response}{response variable for which thresholds will be calculated.}

\item{group}{group variable.}

\item{levels}{relevant levels of \code{group} variable. Should have length 2.}

\item{state}{state level of \code{levels}..}
}
\value{
Returns a list with the following elements:
\item{data}{\code{data.frame} with two columns, containing the response and
group variable for each level in \code{levels} without missings.}
\item{rdf}{ROC dataframe. This is a \code{data.frame} containing sensitivity and
specificity values for all threshold values.}
\item{auc}{Area under the ROC curve.}
\item{response}{Response variable from input data.}
\item{group}{Group variable from the input data.}
\item{levels}{Used levels.}
\item{state}{State level.}
}
\description{
Calculate ROC curve statistics.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
roc(QIDS$QIDS, QIDS$depression, c("No","Yes"), "Yes") |>
  plot(ylim.3=c(0,.2))
}
\author{
Mathijs Deen
}
