% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_find.R
\name{topic_find}
\alias{topic_find}
\title{Retrieves all topics of a specified journal with URLs. Filters results by issue status (open, closed, or all) and optional year range.}
\usage{
topic_find(journal, type = "closed", years = NULL, verbose = TRUE)
}
\arguments{
\item{journal}{MDPI journal code}

\item{type}{"closed", "open" or "all" topics. "closed" by default.}

\item{years}{A vector containing topics closure dates to limit the search to certain years}

\item{verbose}{Logical. If \code{TRUE}, informative messages will be printed during the function execution. Defaults to \code{TRUE}.}
}
\value{
A vector.
}
\description{
Retrieves all topics of a specified journal with URLs. Filters results by issue status (open, closed, or all) and optional year range.
}
\examples{
\dontrun{
topic_find("covid")
}
}
