% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{estimate.map}
\alias{estimate.map}
\title{Load data, estimate a linkage map and plot diagnostics for the fit.}
\usage{
estimate.map(
  fname,
  p = NULL,
  n = NULL,
  ispc = TRUE,
  ndim = 2,
  weightfn = "lod2",
  mapfn = "haldane",
  D1lim = NULL,
  D2lim = NULL,
  D3lim = NULL,
  displaytext = TRUE
)
}
\arguments{
\item{fname}{Character string containing the base file from which the data 
should be read - should contain the complete file name excluding the suffix 
which should be \code{.txt}}

\item{p}{Smoothing parameter.}

\item{n}{Vector of integers or character strings containing the name or 
position in the input list of loci to be excluded from the analysis.}

\item{ispc}{Logical determining the method to be used to estimate the map. By 
default this is \code{TRUE} and the method of principal curves will be used. If 
\code{FALSE} then the constrained MDS method will be used.}

\item{ndim}{Integer the number of dimensions to use if the Principal curves 
method is used. By default this is 2, but it can also be 3.}

\item{weightfn}{Character string specifying the values to use for the weight 
matrix in the MDS \code{lod2} or \code{lod}.}

\item{mapfn}{Character string specifying the map function to use on the 
recombination fractions \code{'haldane'} is default, \code{'kosambi'} or \code{'none'}.}

\item{D1lim}{Numeric vector specifying the limits of the axis relating to 
dimension 1 of the wMDS used to estimate the map.}

\item{D2lim}{Numeric vector specifying the limits of the axis relating to 
dimension 2 of the wMDS used to estimate the map.}

\item{D3lim}{Numeric vector specifying the limits of the axis relating to 
dimension 3 of the wMDS used to estimate the map.}

\item{displaytext}{Logical argument determining how markers should be labelled 
in the wMDS configuration plot. If \code{TRUE} then marker names are used. If 
\code{FALSE} then numbers are used.}
}
\value{
map (s3 class pcmap, pcmap3d or spheremap) from \code{\link{calc.maps.pc}} if \code{ispc=TRUE} or 
\code{\link{calc.maps.sphere}} if \code{ispc=FALSE}.
}
\description{
Load data, estimate a linkage map and plot diagnostics for the fit.
}
\details{
Data is read from a text file which should be of the form described below. 
By default, \code{ispc=TRUE}, in which case maps are estimated using unconstrained 
weighted MDS followed by fitting a principal curve. Details can be found in 
the description of the function \code{\link{calc.maps.pc}}. If \code{ispc=FALSE} 
maps are estimated using spherically constrained weighted MDS. Details can be 
found in the description of the function \code{\link{calc.maps.sphere}}.

\code{ndim} is only relevant if \code{ispc=TRUE}, in which case it specifies the number of 
dimensions to be used, the default is 2 but it can also be 3 dimensions. 

Diagnostic plots are then produced using \code{\link{plot.pcmap}} for the method of 
principal curves in 2 dimensions, \code{\link{plot.pcmap3d}} for the method of principal 
curves in 3 dimensions and \code{\link{plot.spheremap}} for the method using spherically 
constrained MDS.

\code{n} specifies markers to be omitted from the analysis. It can be a vector of 
character strings specifying makers to be omitted, or a vector of integers 
specifying the markers to omit. The latter method is likely to be useful when 
removing outliers after inspection of the diagnostic plot, because the output 
contains a dataframe, locikey, which associates each marker with its 
identifying number. By default this is NULL and all markers in the file will 
be analysed.

\code{p} is a smoothing parameter which operates quite differently depending on 
whether map estimation is performed using Principal Curves or Constrained 
MDS. If the PC method is used, \code{p} determines the smoothing parameter spar in 
the function \code{\link[princurve]{principal_curve}} from the package 
\pkg{princurve}. If \code{NULL} then the most appropriate value will be determined 
using leave one out cross validation. 
If Constrained MDS is used then \code{p} must be set to a number which specifies the 
penalty for deviations from the sphere in the function \code{\link[smacof]{smacofSphere}} from the 
\pkg{smacof} package. Something between 50 and 100 is generally appropriate and this 
penalty can be decreased if stress from the constrained analysis is more than 
about 10% higher than that from the unconstrained MDS (see \code{\link{calc.maps.sphere}} 
for details)

File names should be of the form \code{fname.txt} and it is assumed that they are in 
a tab or space separated file of the format displayed below. The first entry on 
the first row is the number of markers to be analysed. Underneath this is a 
table in which the first two columns contain marker names, the third column 
contains the pairwise recombination fractions between the markers and the 
fourth column the associated LOD score.  Note that marker names in the first 
column vary more slowly than in the second column. Missing recombination pairs 
are acceptable. Recombination fractions greater than 0.499999 are set to that 
value.

\tabular{llll}{
\cr
\code{nmarkers} \tab \tab \tab \cr
\code{marker_1} \tab \code{marker_2} \tab \code{recombination fraction} \tab \code{LOD}\cr
\code{1} \tab \code{2} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
}
}
\examples{
estimate.map(system.file("extdata", "lgI.txt", package="MDSMap"),
ndim=2)
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF in R. J Stat Softw 31: 1-30} \url{https://www.jstatsoft.org/v31/i03/}

\cite{Hastie T, Weingessel A (2013) princurve: Fits a Principal Curve in Arbitrary Dimension. ) R package version 1.1-12.} \url{https://CRAN.R-project.org/package=princurve}
}
\seealso{
\code{\link[smacof]{smacofSphere}}, \code{\link[princurve]{principal_curve}}, \code{\link{calc.maps.pc}}, \code{\link{calc.maps.sphere}}, \code{\link{plot.pcmap}}, \code{\link{plot.pcmap3d}}, \code{\link{plot.spheremap}}
}
