% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plr.R
\name{plr}
\alias{plr}
\alias{plr.numeric}
\alias{plr.matrix}
\title{Fast computation of several simple linear regressions}
\usage{
plr(y, x, addintercept = TRUE)

\method{plr}{numeric}(y, x, addintercept = TRUE)

\method{plr}{matrix}(y, x, addintercept = TRUE)
}
\arguments{
\item{y}{either a vector (of length N) or a matrix (with N rows)}

\item{x}{a matrix with N rows}

\item{addintercept}{boolean. Should the intercept be included in the model by default (TRUE)}
}
\value{
a data frame (if Y is a vector) or list of data frames (if Y is a matrix)
}
\description{
Fast computation of several simple linear regression, where the outcome is analyzed with several 
marginal analyses, or where several outcome are analyzed separately, or a combination of both.
}
\examples{

N <- 1000  # Number of observations
Nx <- 20   # Number of independent variables
Ny <- 80   # Number of dependent variables

# Simulate outcomes that are all standard Gaussians
Y <- matrix(rnorm(N*Ny), ncol=Ny)  
X <- matrix(rnorm(N*Nx), ncol=Nx)

plr(Y, X)

}
\seealso{
\code{mfastLmCpp}
}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{datagen}
